(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["app"] = factory();
	else
		root["app"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "./dev/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./main.js":
/*!*****************!*\
  !*** ./main.js ***!
  \*****************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _src_config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/config/config.js */ "./src/config/config.js");
/* harmony import */ var _src_ketchUp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./src/ketchUp.js */ "./src/ketchUp.js");





let loginOverlay = document.getElementById("Registration");
let nextButton = document.getElementById("nextButton");
let introOverlay = document.getElementById("gamestart");
let paytmSuccess = document.getElementById("paytmSuccess");
let howtoPlayLayout = document.getElementById("howToPlay");


/** @type {import ("./typings/types")} */

let otpOverlay = document.getElementById("otpOverlay");
let doneButton = document.getElementById("confirmButton");
let startGameBtn = document.getElementById("startGameBtn");
let termAndConditionClick = document.getElementById("termAndConditionClick");
let termAndConditionClick1 = document.getElementById("termAndConditionClick1");
let termAndConditionClick2 = document.getElementById("termAndConditionClick2");
var g_gameServer;

window.addEventListener('load', (event) => {
    showLoginPage();
    g_gameServer = new GameServer();
    var Phaser = Phaser;
});

nextButton.addEventListener("click", () => {
    var nameValue = document.getElementById("nameInput").value;
    var mobileNumVal =  document.getElementById("mobileNumber").value;
    var checkBox = document.getElementById("mycheck");
    var mobileNumberValid;
    var nameValid;
    var checkBoxValid
    if(/^\d{10}$/.test(mobileNumVal)) 
        mobileNumberValid = true;
    else{
        mobileNumberValid = false;
        document.getElementById("mobileNumberError").style.display = "block";
    }
    if(nameValue != "")
        nameValid = true;
    else {
        nameValid = false;
        document.getElementById("nameErrorId").style.display = "block";
    }
    if(checkBox.checked == true)
         checkBoxValid = true;
    else {
         checkBoxValid = false;
         document.getElementById("checkBoxerrorId").style.display = "block";
    }
    if(mobileNumberValid && nameValid && checkBoxValid) {
        g_gameServer.createPlayer(nameValue,mobileNumVal)
        hideLoginPage();
        showOtpPage();
    }
});

function hideLoginPage() {
    loginOverlay.style.display = "none";
}

function showLoginPage() {
    loginOverlay.style.display = "block";
}

function showOtpPage() {
    otpOverlay.style.display = "block";
    loginOverlay.style.display = "none";
}

function hideotpPage() {
    otpOverlay.style.display = "none";
}

doneButton.addEventListener("click", () => {
    var otpEnteredVal =  document.getElementById("otpValue").value;
    if(otpEnteredVal != ""){
        g_gameServer.sendOtp(otpEnteredVal);
    } else{
        document.getElementById("otpError").style.display = "block";
    }
});

startGameBtn.addEventListener("click", () => {
    hideIntroPage();
    loadGame();
});

paytmButton.addEventListener("click", () => {
    var paytmnumberValid;
    var paytmnumber =  document.getElementById("paytmnumberId").value;
    if(/^\d{10}$/.test(paytmnumber)) 
         paytmnumberValid = true;
    else{
        paytmnumberValid = false;
        document.getElementById("mobileNumberId").style.display = "block";
    }
    if(paytmnumberValid){
        document.getElementById("paytmPanel").style.display = "none";
        paytmSuccess.style.display = "block";
        g_gameServer.sendPaytm(paytmnumber);
    }
});

homeButton.addEventListener("click", ()  => {
    refereshPage();
});

termAndConditionClick.addEventListener("click", () => {
    openTermsAndConditions();
});
termAndConditionClick1.addEventListener("click", () => {
    openTermsAndConditions();
});

termAndConditionClick2.addEventListener("click", () => {
    openTermsAndConditions();
});


howtoplayClick.addEventListener("click", () => {
    introOverlay.style.display ="none";
    howtoPlayLayout.style.display ="block";

});

backArrowBtn.addEventListener("click", () => {
    introOverlay.style.display ="block";
    howtoPlayLayout.style.display ="none";
})



function refereshPage() {
        localStorage.clear();
        location.reload();
}

function showIntroPage() {
    introOverlay.style.display = "block";
}

function hideIntroPage() {
    introOverlay.style.display = "none";
}

// g_gameServer.sendPaytm("8610201155");

function openTermsAndConditions() {
    var popup = $("#termsAndCondition");
    if (popup.length == 0) {
      $("body").append(TermsAndConditionsHTML);
      popup = $("#termsAndCondition");
      $("#termsAndCondition .closePopup").on("click", function () {
        closeTermsAndConditions();
      });
    }
    $("#termsAndCondition").show();
}

function closeTermsAndConditions() {
    $("#termsAndCondition").hide();
}

window.checkOtpValidation=function(otpStatus) {
    if(otpStatus != 200){
        document.getElementById("otpError").style.display = "block";
    } else {
          hideotpPage();   
          showIntroPage();
    }
}

function loadGame(){
      new Game();
}

class Game extends Phaser.Game {
	constructor() {
		super(_src_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
		this.scene.add(_src_ketchUp_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
		this.scene.start("ketchUp");
	}
}




/***/ }),

/***/ "./src/config/config.js":
/*!******************************!*\
  !*** ./src/config/config.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scenes/LoadScene.js */ "./src/scenes/LoadScene.js");
/* harmony import */ var _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scenes/GameScene.js */ "./src/scenes/GameScene.js");


/* harmony default export */ __webpack_exports__["default"] = ({
  type: Phaser.CANVAS,
  parent: "game",
  width: window.innerWidth * window.devicePixelRatio,
  height: window.innerHeight * window.devicePixelRatio,
  transparent: true,
  scale: {
    mode: Phaser.Scale.ENVELOP
  },
  devicePixelRatio: window.devicePixelRatio,
  scene: [_scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__["default"], _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__["default"]],
  physics: {
    default: "arcade",
    arcade: {
      gravity: {
        x: 0,
        y: 0
      }
    }
  }
});

/***/ }),

/***/ "./src/ketchUp.js":
/*!************************!*\
  !*** ./src/ketchUp.js ***!
  \************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ketchUp; });
/* harmony import */ var _scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scenes/LoadScene.js */ "./src/scenes/LoadScene.js");
/* harmony import */ var _scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scenes/GameScene.js */ "./src/scenes/GameScene.js");




class ketchUp {
  constructor() {
    this.scene.add(_scenes_LoadScene_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
    this.scene.add(_scenes_GameScene_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    this.scene.start("Load");
  }

}

/***/ }),

/***/ "./src/scenes/GameScene.js":
/*!*********************************!*\
  !*** ./src/scenes/GameScene.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../config/config.js */ "./src/config/config.js");

let paytmPanel = document.getElementById("paytmPanel");

class GameScene extends Phaser.Scene {
  constructor() {
    super("Game");
    this.sensorBool = false;
  }

  init() {}

  preload() {}

  create() {
    this.calculateAspectRatio();
    this.createBackground();
    this.addStartPlayButton();
    this.addLogoAndBottle(); //elements for shake scene

    this.addGameBackground();
    this.addClosedBottle();
    this.addShakeInstruction();
    this.addOpenBottle();
    this.lidFlyAnimation();
    this.addSplashSpots();
    this.xGammaThreshold = 30;
    this.lastX = 0;
    this.finalBool = false;
  }

  calculateAspectRatio() {
    console.log("config", _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio);
    if (_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio <= 2) this.currentScale = 0.5;else this.currentScale = 1;
  }

  createBackground() {
    this.background = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.1, "bg").setScale(this.currentScale + 0.8).setOrigin(0.5);
    console.log("this.background", this.background, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
  }

  addStartPlayButton() {
    this.playButton = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.9, "startplayButton").setScale(this.currentScale + 0.4).setInteractive().on('pointerdown', () => this.destroyIntialScreen());
    ;
  }

  addSplashSpots() {
    this.splashOne = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.28, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.7, "splashSpot").setScale(0.1).setAlpha(0);
    this.splashTwo = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.7, "splashSpot").setScale(0.1).setAlpha(0);
    this.splashThree = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.73, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.7, "splashSpot").setScale(0.1).setAlpha(0);
  }

  addLogoAndBottle() {
    var scaleUnit;
    _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio <= 2 ? scaleUnit = 0.6 : scaleUnit = 0.9;
    this.bottleSplatter = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.6, "bottleIntro").setScale(scaleUnit);
    this.logoUnit = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.23, "logounit").setScale(scaleUnit);
  }

  destroyIntialScreen() {
    var g_gameServer = new GameServer();

    var _self = this;

    var tween = this.tweens.add({
      targets: this.playButton,
      alpha: 0,
      duration: 1000,
      ease: "Power2",
      onComplete: function () {
        _self.bgTransition();
      }
    });
    var tweenOne = this.tweens.add({
      targets: [this.bottleSplatter, this.logoUnit],
      scale: 0,
      duration: 1000,
      ease: "Bounce.easeOut"
    });
  }

  bgTransition() {
    var _self = this;

    var tweenOne = this.tweens.add({
      targets: this.background,
      alpha: 0,
      duration: 1000,
      ease: "Bounce.easeOut"
    });
    var tweenTwo = this.tweens.add({
      targets: [this.gameBackground, this.tomato, this.inGameLogo],
      alpha: 1,
      duration: 1000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.bottleFallEffect();
      }
    });
  }

  bottleFallEffect() {
    var _self = this;

    this.gameBottle.setAlpha(1);
    var tweenBottle = this.tweens.add({
      targets: this.gameBottle,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.7,
      duration: 2000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.showShakeInstruction();
      }
    });
  }

  showShakeInstruction() {
    var _self = this;

    this.gameBottle.setInteractive().on('pointerdown', () => _self.initiateScreenShake()); // DeviceMotionEvent.DeviceMotionEvent();
    // var gn = new GyroNorm();
    // gn.init().then(function(){
    //     alert('success');
    //     gn.start(function(data){
    //         this.gameBottle.setAlpha(0);
    //             // $(".stats").html(
    //             //         'alpha: '+data.do.alpha+', beta:'+data.do.beta+', gamma:'+data.do.gamma
    //             //  );
    //     });
    // }).catch(function(e){
    //     alert(e);
    // if (window.DeviceOrientationEvent) {
    //     window.addEventListener('deviceorientation', (eventData) => {
    //         var current = eventData.gamma;
    //         if ((this.lastX === null)) {
    //             this.lastX = current;
    //             return;
    //         }
    //        var deltaX = Math.abs(this.lastX - current);
    //         if (deltaX > this.xGammaThreshold) {
    //             if(!this.sensorBool) {
    //                 this.sensorBool = true;
    //                 _self.initiateScreenShake();
    //             }
    //         }
    //     });
    // } else {
    //     window.alert("not supported")
    // }
    // const options = { frequency: 60, referenceFrame: 'device' };
    // const sensor = new AbsoluteOrientationSensor(options);
    // window.alert("sensor");
    // sensor.addEventListener('reading', () => {
    //     this.gameBottle.setAlpha(0);
    // });
    // sensor.addEventListener('error', error => {
    //      window.alert("not supported")
    //     });
    //     sensor.start();
  }

  initiateScreenShake() {
    this.gameBottle.removeInteractive();
    this.gameBottle.setAlpha(0);
    this.openBottle.setAlpha(1);
    this.lidPathAnimation();
    this.bottleAnimationLeft();
    this.shakeInstruction.setAlpha(0);
    this.cameras.main.shake(1500);
  }

  bottleAnimationLeft() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      x: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.1,
      duration: 500,
      yoyo: true,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.bottleAnimationRight();
      }
    });
  }

  bottleAnimationRight() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      x: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 1,
      duration: 500,
      yoyo: true,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.dropBottle();
      }
    });
  }

  addGameBackground() {
    var scaleUnit;
    _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio <= 2 ? scaleUnit = 1 : scaleUnit = 2;
    this.gameBackground = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.5, "gamebackground").setScale(scaleUnit).setAlpha(0);
    this.tomato = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.95, "tomato").setAlpha(0);
    this.inGameLogo = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.2, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.16, "logounit").setScale(0.4).setAlpha(0);
  }

  addClosedBottle() {
    var scaleUnit;
    _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio <= 2 ? scaleUnit = 0.6 : scaleUnit = 0.9;
    this.gameBottle = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.53, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.01, "gameBottle").setScale(scaleUnit).setAlpha(0);
  }

  addOpenBottle() {
    var scaleUnit;
    _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].devicePixelRatio <= 2 ? scaleUnit = 0.6 : scaleUnit = 0.9;
    this.openBottle = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.53, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.7, "openBottle").setScale(scaleUnit).setAlpha(0);
  }

  addShakeInstruction() {
    this.shakeInstruction = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.2, "gameInst").setAlpha(0);
  }

  lidFlyAnimation() {
    this.pathgraphics = this.add.graphics();
    let points = [];
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.5));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.52, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.47));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.55, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.42));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.6, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.35));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.65, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.3));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.7, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.25));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.75, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.2));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.8, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.15));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.85, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.1));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.9, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.05));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.95, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.02));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 1, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.001));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 1.3, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.001));
    points.push(new Phaser.Math.Vector2(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 1.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.001));
    this.points = points;
    this.curve = new Phaser.Curves.Spline(points);
  }

  lidPathAnimation() {
    var _self = this;

    this.pathgraphics.clear();
    var lidAnim = this.add.follower(this.curve, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.54, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.415, "bottlelid").setScale(0.9);
    lidAnim.startFollow({
      duration: 3000,
      ease: "Bounce.easeOut",
      onComplete: function () {}
    });
  }

  dropBottle() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 1,
      duration: 2000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.getSauceOutLeft();
      }
    });
  }

  getSauceOutLeft() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      angle: -25,
      duration: 2000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.spitSauceLeft();
      }
    });
  }

  spitSauceLeft() {
    var _self = this;

    this.splashOne.setAlpha(1);
    var tweenBottle = this.tweens.add({
      targets: this.splashOne,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.5,
      scale: 0.8,
      duration: 1000,
      ease: "Circ.easeInOut",
      onComplete: function () {
        _self.getSauceOutRight();
      }
    });
  }

  getSauceOutRight() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      angle: 15,
      duration: 2000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.spitSauceRight();
      }
    });
  }

  spitSauceRight() {
    var _self = this;

    this.splashThree.setAlpha(1);
    var tweenBottle = this.tweens.add({
      targets: this.splashThree,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.5,
      scale: 0.8,
      duration: 1000,
      ease: "Circ.easeInOut",
      onComplete: function () {
        _self.getSauceOutMiddle();
      }
    });
  }

  getSauceOutMiddle() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      angle: 0,
      duration: 2000,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.spitSauceMiddle();
      }
    });
  }

  spitSauceMiddle() {
    var _self = this;

    this.splashTwo.setAlpha(1);
    var tweenBottle = this.tweens.add({
      targets: this.splashTwo,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.3,
      scale: 0.8,
      duration: 1000,
      ease: "Circ.easeInOut",
      onComplete: function () {
        if (!_self.finalBool) {
          _self.finalBool = true;

          _self.setInteractiveProperty();
        }
      }
    });
  }

  setInteractiveProperty() {
    g_gameServer.getKetchupScore();
    this.splashOne.setInteractive().on('pointerdown', () => this.getSplashOneValue());
    this.splashTwo.setInteractive().on('pointerdown', () => this.getSplashTwoValue());
    this.splashThree.setInteractive().on('pointerdown', () => this.getSplashThreeValue());
  }

  getSplashOneValue() {
    this.splashOne.removeInteractive();
    this.splashTwo.setAlpha(0.5);
    this.splashThree.setAlpha(0.5);
    this.startTimer(this.splashOne);
  }

  getSplashTwoValue() {
    this.splashTwo.removeInteractive();
    this.splashOne.setAlpha(0.5);
    this.splashThree.setAlpha(0.5);
    this.startTimer(this.splashTwo);
  }

  getSplashThreeValue() {
    this.splashThree.removeInteractive();
    this.splashTwo.setAlpha(0.5);
    this.splashOne.setAlpha(0.5);
    this.startTimer(this.splashThree);
  }

  startTimer(object) {
    console.warn("startTimer");

    var _self = this;

    this.time.addEvent({
      delay: 2500,
      callback: () => {
        _self.destroySceneObjects();
      }
    });
  }

  destroySceneObjects() {
    var _self = this;

    var tweenBottle = this.tweens.add({
      targets: this.openBottle,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 1.5,
      duration: 1000,
      ease: "Power",
      onComplete: function () {}
    });
    var splashScale = this.tweens.add({
      targets: [this.splashOne, this.splashTwo, this.splashThree],
      scale: 0,
      duration: 1000,
      ease: "Power",
      onComplete: function () {
        _self.playSplatterAnimation();
      }
    });
  }

  playSplatterAnimation() {
    console.warn("playsplatter");

    var _self = this;

    this.splatter = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.5, "splatter").setScale(0.1).setAlpha(0);
    var splashScale = this.tweens.add({
      targets: this.splatter,
      scale: 1.5,
      angle: 180,
      alpha: 1,
      duration: 800,
      ease: "Bounce.easeOut",
      onComplete: function () {
        _self.displayCashBackText();

        _self.addClaimbackButton();
      }
    });
  }

  displayCashBackText() {
    this.winText = this.add.text(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.3, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.3, "YOU HAVE WON").setFontFamily("Arial").setColor("#000000").setFontSize(50);
    this.cashBackAmount = this.add.text(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.4, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.43, g_cashBack + "").setFontFamily("Arial").setColor("#FFFFFF").setFontSize(150);
    this.cashBackText = this.add.text(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.4, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.53, "CASHBACK").setFontFamily("Arial").setColor("#FFFFFF").setFontSize(40);
  }

  addClaimbackButton() {
    this.claimcahbackButton = this.add.image(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width * 0.5, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height * 0.9, "claimCashBack").setScale(this.currentScale + 0.4).setInteractive().on('pointerdown', () => this.showPaytmClaimScreen());
    ;
  }

  showPaytmClaimScreen() {
    console.log("this.splatter", this.splatter, this.claimcahbackButton);
    this.splatter.setAlpha(0);
    this.winText.setAlpha(0);
    this.cashBackAmount.setAlpha(0);
    this.cashBackText.setAlpha(0);
    this.claimcahbackButton.setAlpha(0);
    paytmPanel.style.display = "block";
  }

}

/* harmony default export */ __webpack_exports__["default"] = (GameScene);

/***/ }),

/***/ "./src/scenes/LoadScene.js":
/*!*********************************!*\
  !*** ./src/scenes/LoadScene.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _config_config_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../config/config.js */ "./src/config/config.js");


class LoadScene extends Phaser.Scene {
  constructor() {
    super("Load");
  }

  preload() {
    console.log("--- LOAD PRELOAD ---"); //PROGRESS BAR

    let progressBar = this.add.graphics();
    let progressBox = this.add.graphics();
    progressBox.fillStyle(0x222222, 0.8);
    progressBox.fillRect(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width / 2 - 150, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height / 2 - 30, 320, 50); //LOADING TEXT

    let loadingText = this.make.text({
      x: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width / 2,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height / 2 - 50,
      text: "Loading...",
      style: {
        font: "20px monospace",
        fill: "#ffffff"
      }
    });
    loadingText.setOrigin(0.5, 0.5); //PERCENT TEXT

    let percentText = this.make.text({
      x: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width / 2,
      y: _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height / 2 - 5,
      text: "0%",
      style: {
        font: "18px monospace",
        fill: "#ffffff"
      }
    });
    percentText.setOrigin(0.5, 0.5); // load assets declared in the preload config

    this.loadImages();
    this.loadAudio();
    this.loadAnimations();
    this.load.on("progress", function (value) {
      progressBar.clear();
      progressBar.fillStyle(0xffffff, 1);
      progressBar.fillRect(_config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].width / 2 - 140, _config_config_js__WEBPACK_IMPORTED_MODULE_0__["default"].height / 2 - 20, 300 * value, 30);
      percentText.setText(parseInt(value * 100) + " %");
    });
    this.load.on("fileprogress", function (file) {});
    this.loadComplete = false;
    this.load.on("complete", function () {
      progressBar.destroy();
      progressBox.destroy();
      loadingText.destroy();
      percentText.destroy();
      this.loadComplete = true;
    });
  }

  create() {
    this.scene.start("Game");
  }

  loadAnimations() {}

  loadImages() {
    this.load.image("bg", "assets/img/ketchup/Home.png");
    this.load.image("basket", "assets/img/basket.png");
    this.load.image("startplayButton", "assets/img/ketchup/StartPlayingButton.png");
    this.load.image("logounit", "assets/img/ketchup/LogoUnit.png");
    this.load.image("bottleIntro", "assets/img/ketchup/Bottleintro.png");
    this.load.image("gamebackground", "assets/img/ketchup/GameScreenBG.jpg");
    this.load.image("gameBottle", "assets/img/ketchup/GameBottle.png");
    this.load.image("gameInst", "assets/img/ketchup/gameInst.png");
    this.load.image("openBottle", "assets/img/ketchup/OpenBottle.png");
    this.load.image("bottlelid", "assets/img/ketchup/BottleCap.png");
    this.load.image("splashSpot", "assets/img/ketchup/KetchUpSplash.png");
    this.load.image("splatter", "assets/img/ketchup/Splatter.png");
    this.load.image("claimCashBack", "assets/img/ketchup/ClaimCashback.png");
    this.load.image("tomato", "assets/img/ketchup/Tomato.png");
  }

  loadAudio() {}

}

/* harmony default export */ __webpack_exports__["default"] = (LoadScene);

/***/ }),

/***/ 0:
/*!***********************!*\
  !*** multi ./main.js ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /Users/sindujarajadurai/Desktop/ketchup/main.js */"./main.js");


/***/ })

/******/ });
});
//# sourceMappingURL=app.js.map